function [results] = get_fitting_concs(SOI, results, core, D, n, z_pc, to_save)

% this function calculates RMSE as a measure of misfit. It adds results to
% the struct intially produced in all_model_concs.m and saves as a new
% mat.file if to_save == 1.

% check core being analysed
if core == 2
    name = 'BH02';
elseif core == 3 
    name = 'BH03';
else 
    name = 'BH06';
end

d=D.(name); % set name
numits = length(results.N14_final); % get numits

% get predictions of concs at sample mid-depths for samples of interest.
mid_pred = (SOI * 3) - 1; % defines sequence of mid-depth predictions within results [2, 5, 8, 11 and so on if there were more samples]
mid_predictions = results.N14_final(:, [mid_pred]);

% Use RMSE as a simple measure of misfit between model (mid_predictions and
% data *d.n14_concs. This isn't error weighted but with only a few
% measurements and reasonably consistent errors this is probably OK. 
M2 = zeros(length(numits),1);
for i = 1:numits
M2(i) = sqrt(mean(mid_predictions(i,:) - d.n14_concs([SOI])') .^2);
end
M2 = M2';

% get iterations in ascending order of fit to return
[~, minpc] = sort(M2,'ascend');
np = n/100;
ind = numits * np;
minpc = minpc(1:ind); % this is now indices (in orignal results) of best fitting n% of iterations

results.N14_clip10 = results.N14_final(minpc,:); % N.B results are in order of fit which is handy
results.Ts_clip10 = results.Ts(minpc,:);
results.Zs_clip10 = results.Zs(minpc,:);
results.core = name;
results.numits = numits;
% results.bounds = bounds;
% results.M = M;
results.M2 = M2;
results.Mclip = M2(minpc,:);
results.date = datestr(now, 'dd-mmm-yyyy'); 

% now save if that option selected
if to_save == 1
save_name = strcat('fitting_model_results','_',name,'_',datestr(now, 'dd-mmm-yyyy'),'_',num2str(numits),'_',num2str(z_pc),'_fix_RMSE');
save(save_name, 'results')
end

end